<?php
/*
Profile Views
by: BleepyEvans
http://www.cybertechforums.com
Copyright 2011  CyberTechForums.com

############################################
License Information:

Links to http://www.cybertechforums.com must remain unless
branding free option is purchased.
#############################################
Thanks to Aries-Belgium for teaching me 
how to create these plugins
#############################################
*/


if(!defined('IN_MYBB'))
	die('This file cannot be accessed directly.');
	
$plugins->add_hook("member_profile_end", "profileviews_profile");

function profileviews_info()
	{
		$donate_button = 
		'<a href="https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=XJBJRJ98BRLCY" style="float:right;margin-top:-8px;padding:4px;" target="_blank"><img src="https://www.paypalobjects.com/WEBSCR-640-20110306-1/en_US/i/btn/btn_donate_SM.gif" /></a>';

		return array('name'      => 'هاك عدد مشاهداة الملف الشخصي',
                 'description'   => 'يقوم باضاقة خانة جديدة بها عدد مشاهدات الملف الشخصي للعضو.',
                 'website'       => 'http://cybertechforums.com',
                 'author'        => 'BleepyEvans',
                 'authorsite'    => 'http://cybertechforums.com',
                 'version'       => '1.2.1',
                 'compatibility' => '1*',
                 'guid'		     => 'b5ca7104ed2d14a13b7475d280220d37'
                );
	}

	
function profileviews_install()
	{
		// load the $db variable of MyBB in our function
		global $db;
		// add the column to the database
        $db->query("ALTER TABLE  ".TABLE_PREFIX."users ADD  `views` INT UNSIGNED NOT NULL");
		
		// get the last disporder in the settinggroups table
		$query = $db->simple_select("settinggroups", "MAX(disporder) as max_disporder");
		$max_disporder = $db->fetch_field($query, "max_disporder");
	
		// insert our own settinggroup
		$gid = $db->insert_query("settinggroups",
			array(
				'name' => "profileviews",
				'title' => "هاك عدد مشاهدات الملف الشخصي",
				'description' => "اعدادات هاك مشاهدات الملف الشخصي",
				'disporder' => $max_disporder+1,
				'isdefault' => 0
			)
		);
		
		// insert the setting into the settings table
		$db->insert_query( "settings" ,
			array(
				'name' => "profileviews_ownprofile",
				'title' => "مشاهدات العضو لملفه الشخصي",
				'description' => "هل تريد ان يحتسب زيارات العضو لملفة الشخصي",
				'optionscode' => "yesno",
				'value' => "yes",
				'disporder' => 0,
				'gid' => (int)$gid
			)
		);
		
		$db->insert_query( "settings" ,
			array(
				'name' => "profileviews_guest",
				'title' => "مشاهدات الزوار",
				'description' => "هل تريد تفعيل مشاهدات الزوار الغير مسجلين ؟",
				'optionscode' => "yesno",
				'value' => "yes",
				'disporder' => 0,
				'gid' => (int)$gid
			)
		);
	}


function profileviews_is_installed()
	{
		global $db;
        // check if the column exists in the database
        $query = $db->query("SHOW COLUMNS FROM ".TABLE_PREFIX."users LIKE 'views'");
        if($db->num_rows($query) == 1)
			{
                // if the column exists return true
                return true;
			}
        // otherwise return false
        return false;
	}
   
   
function profileviews_uninstall()
	{
		// load the $db variable of MyBB in our function
		global $db;
		//delete column from the database
		$db->query("ALTER TABLE  ".TABLE_PREFIX."users DROP  `views`");
		
		// get the gid of our settinggroups
		$query = $db->simple_select("settinggroups", "gid" , "name='profileviews'");
		$gid = (int)$db->fetch_field($query, "gid");
		// remove all settings in the group
		$db->delete_query("settings", "gid={$gid}" );
		// remove the settinggroup itself
		$db->delete_query("settinggroups", "gid={$gid}" );
	}
	
function profileviews_activate()
{
	// put a variable in the member_profile template we can assign our own template output to
	include MYBB_ROOT."/inc/adminfunctions_templates.php";
	find_replace_templatesets("member_profile", "/(".preg_quote("{\$referrals}").")/i", "{\$profile_views}\n$1");
}

function profileviews_deactivate()
{
	// remove our variable in the member_profile template
	include MYBB_ROOT."/inc/adminfunctions_templates.php";
	find_replace_templatesets("member_profile", "/".preg_quote("{\$profile_views}\n")."/i", "", 0);
}

function profileviews_profile()
	{
		// include $uid and $db from the global scope
		global $uid, $db, $mybb;
		
		// put our own variable in the global scope
		global $profile_views;
		
		// get the views out the database for the $uid
		$query = $db->simple_select("users", "views", "uid=".(int)$uid);
		// check if any records were fetched from the table
		if($db->num_rows($query) === 1)
		{
			// the user exists and the views variable can be fetched
			$views = (int)$db->fetch_field($query,"views");
			
			// if the ownprofile setting isn't loaded set to (1) yes as default
			if(!isset($mybb->settings['profileviews_ownprofile']))
				{
					$mybb->settings['profileviews_ownprofile'] = 1;
				}
			
			// if the ownprofile setting isn't loaded set to (1) yes as default
			if(!isset($mybb->settings['profileviews_guest']))
				{
					$mybb->settings['profileviews_guest'] = 1;
				}
			
			// if the ownprofile setting is enabled go through anyway
			// otherwise check the uid
			if(
				($mybb->user['uid'] == 0 && $mybb->settings['profileviews_guest'] != 1) ||
				($mybb->user['uid'] == $uid && $mybb->settings['profileviews_ownprofile'] != 1)
			)
			{
			// do nothing
			}
			Else
			{
				// now we're going to increase it by one and save it to the database
				$views = $views + 1;
				$db->update_query("users", array('views' => $views), "uid=".(int)$uid);
			}
			
			// put all the information into the $profile_views variable
			$bg_color = alt_trow();
			$profile_views = "<tr><td class=\"{$bg_color}\"><strong>مشاهدات الملف الشخصي</strong></td><td class=\"{$bg_color}\">{$views}</td></tr>";
		}
	}